/* -*-c++-*- Copyright (C) 2018 Advanced Driver Information Technology.
 *
 * This library is open source and may be redistributed and/or modified under
 * the terms of the OpenSceneGraph Public License (OSGPL) version 0.0 or
 * (at your option) any later version.  The full license is in LICENSE file
 * included with this distribution, and on the openscenegraph.org website.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * OpenSceneGraph Public License for more details.
*/

#ifndef WAYLANDBACKEND_WLREGISTRY
#define WAYLANDBACKEND_WLREGISTRY 1

#include <wayland-client.h>

namespace WaylandBackend
{

class WLRegistry
{
public:
    WLRegistry(struct wl_display *wlDisplay, struct wl_event_queue *eventQ);
    virtual ~WLRegistry();
    
    struct wl_registry * getRegistry() {return _wlRegistry;}
    
    virtual void registryGlobal(struct wl_registry* registry,
                                uint32_t name, const char* interface,
                                uint32_t version) = 0;

    virtual void registryGlobalRemove(struct wl_registry* registry,
                                      uint32_t name) = 0;

private:
    struct wl_registry *_wlRegistry;
    static const wl_registry_listener _registryListener;
    static void registryHandleGlobal(void* data, struct wl_registry* registry,
                                     uint32_t name, const char* interface,
                                     uint32_t version);
    static void registryHandleGlobalRemove(void* data,
                                           struct wl_registry* registry,
                                           uint32_t name);
};

}

#endif
